%estymuje obraz i wyznacza mape przesuniec



rozmiar=size(film);
rozx=rozmiar(1);
rozy=rozmiar(2);
rozt=rozmiar(3);

Ex=[];
Ey=[];
Et=[];
clear E Exx Eyy Ett us1 vs1;
a=str2num(get(hedit1,'string'));        % wspolczynnik alfa
iter=str2num(get(hedit2,'string'));     %liczba iteracji
t=str2num(get(hedit3,'string'));        %klatka do estymacji
if t>(rozt-1)
    t=rozt-1
end

E=double(film);
for i=1:rozx
    for j=1:rozy
            if i<rozx
                if j<rozy   %piksle w srodku obrazu (nie dotykajace prawej krawedzi obrazu)
                    Ex=(E(i,j+1,t)-E(i,j,t)+E(i+1,j+1,t)-E(i+1,j,t)+E(i,j+1,t+1)-E(i,j,t+1)+E(i+1,j+1,t+1)-E(i+1,j,t+1))/4;
                    Ey=(E(i+1,j,t)-E(i,j,t)+E(i+1,j+1,t)-E(i,j+1,t)+E(i+1,j,t+1)-E(i,j,t+1)+E(i+1,j+1,t+1)-E(i,j+1,t+1))/4;
                    Et=(E(i,j,t+1)-E(i,j,t)+E(i+1,j,t+1)-E(i+1,j,t)+E(i,j+1,t+1)-E(i,j+1,t)+E(i+1,j+1,t+1)-E(i+1,j+1,t))/4;
                    
                else        %piksle na krawedzi - dotykajace prawej krawedzi obrazu (estymacja malo dokladna, wykonana
                            %w celu zachowania rozmiarow obrazu)
                    Ex=(E(i,j,t)-E(i,j,t)+E(i+1,j,t)-E(i+1,j,t)+E(i,j,t+1)-E(i,j,t+1)+E(i+1,j,t+1)-E(i+1,j,t+1))/4;
                    Ey=(E(i+1,j,t)-E(i,j,t)+E(i+1,j,t)-E(i,j,t)+E(i+1,j,t+1)-E(i,j,t+1)+E(i+1,j,t+1)-E(i,j,t+1))/4;
                    Et=(E(i,j,t+1)-E(i,j,t)+E(i+1,j,t+1)-E(i+1,j,t)+E(i,j,t+1)-E(i,j,t)+E(i+1,j,t+1)-E(i+1,j,t))/4;
                end
            elseif j<rozy   %Piksle na krawedzi - dotykajace dolnej krawedzi obrazu (nie dotykajace prawej)
                            %estymacja malo dokladna, wykonana w celu zachowania rozmiarow obrazu
                Ex=(E(i,j+1,t)-E(i,j,t)+E(i,j+1,t)-E(i,j,t)+E(i,j+1,t+1)-E(i,j,t+1)+E(i,j+1,t+1)-E(i,j,t+1))/4;
                Ey=(E(i,j,t)-E(i,j,t)+E(i,j+1,t)-E(i,j+1,t)+E(i,j,t+1)-E(i,j,t+1)+E(i,j+1,t+1)-E(i,j+1,t+1))/4;
                Et=(E(i,j,t+1)-E(i,j,t)+E(i,j,t+1)-E(i,j,t)+E(i,j+1,t+1)-E(i,j+1,t)+E(i,j+1,t+1)-E(i,j+1,t))/4;
            else            %Piksel na krawedzi - prawy dolny rog (dotyczy tylko jednego piksela)
                            %estymacja malo dokladna, wykonana w celu zachowania rozmiarow obrazu
                Ex=(E(i,j,t)-E(i,j,t)+E(i,j,t)-E(i,j,t)+E(i,j,t+1)-E(i,j,t+1)+E(i,j,t+1)-E(i,j,t+1))/4;
                Ey=(E(i,j,t)-E(i,j,t)+E(i,j,t)-E(i,j,t)+E(i,j,t+1)-E(i,j,t+1)+E(i,j,t+1)-E(i,j,t+1))/4;
                Et=(E(i,j,t+1)-E(i,j,t)+E(i,j,t+1)-E(i,j,t)+E(i,j,t+1)-E(i,j,t)+E(i,j,t+1)-E(i,j,t))/4;
            end
            
            %skladowe natezenia w kierunku x,y,t (macierze)
            Exx(i,j)=Ex;
            Eyy(i,j)=Ey;
            Ett(i,j)=Et;
                    
            du=1/(Ex*Ex+Ey*Ey+a*a);
            dv=du;
            duu(i,j)=du;
            
            %poczatkowe wektory predkosci optycznej (poczatkowe)
            u1=-Ex*Et*du;       
            v1=-Ey*Et*dv;
            
            %tablice z poczatkowymi predkosciami optycznymi
            u(i,j)=u1;
            v(i,j)=v1;
                    
    end
end
%wyznaczanie predkosci optycznych (srednich)
for i=1:rozx
    for j=1:rozy
       
            
            if (i>1 & i<rozx)
                if (j>1 & j<rozy)   %srodek obrazu
                    us=(2*(u(i-1,j)+u(i+1,j)+u(i,j-1)+u(i,j+1))+(u(i-1,j-1)+u(i+1,j-1)+u(i-1,j-1)+u(i+1,j+1)))/12;
                    vs=(2*(v(i-1,j)+v(i+1,j)+v(i,j-1)+v(i,j+1))+(v(i-1,j-1)+v(i+1,j-1)+v(i-1,j-1)+v(i+1,j+1)))/12;
                elseif j>1          %krawedz lewa
                    us=(2*(u(i-1,j)+u(i+1,j)+u(i,j-1)+u(i,j))+(u(i-1,j-1)+u(i+1,j-1)+u(i-1,j-1)+u(i+1,j)))/12;
                    vs=(2*(v(i-1,j)+v(i+1,j)+v(i,j-1)+v(i,j))+(v(i-1,j-1)+v(i+1,j-1)+v(i-1,j-1)+v(i+1,j)))/12;
                else                %krawedz prawa
                    us=(2*(u(i-1,j)+u(i+1,j)+u(i,j)+u(i,j+1))+(u(i-1,j)+u(i+1,j)+u(i-1,j)+u(i+1,j+1)))/12;
                    vs=(2*(v(i-1,j)+v(i+1,j)+v(i,j)+v(i,j+1))+(v(i-1,j)+v(i+1,j)+v(i-1,j)+v(i+1,j+1)))/12;
                end
            elseif (i>1 & j>1 & j<rozy)     %dol obrazu
                us=(2*(u(i-1,j)+u(i,j)+u(i,j-1)+u(i,j+1))+(u(i-1,j-1)+u(i,j-1)+u(i-1,j-1)+u(i,j+1)))/12;
                vs=(2*(v(i-1,j)+v(i,j)+v(i,j-1)+v(i,j+1))+(v(i-1,j-1)+v(i,j-1)+v(i-1,j-1)+v(i,j+1)))/12;
            elseif (j>1 & j<rozy)           %gora obrazu
                us=(2*(u(i,j)+u(i+1,j)+u(i,j-1)+u(i,j+1))+(u(i,j-1)+u(i+1,j-1)+u(i,j-1)+u(i+1,j+1)))/12;
                vs=(2*(v(i,j)+v(i+1,j)+v(i,j-1)+v(i,j+1))+(v(i,j-1)+v(i+1,j-1)+v(i,j-1)+v(i+1,j+1)))/12;
            else                            %piksle znajdujace sie na rogach estymowanego obrazka
                us=(2*(u(i,j)+u(i,j)+u(i,j)+u(i,j))+(u(i,j)+u(i,j)+u(i,j)+u(i,j)))/12;
                vs=(2*(v(i,j)+v(i,j)+v(i,j)+v(i,j))+(v(i,j)+v(i,j)+v(i,j)+v(i,j)))/12;
            end
            uss(i,j)=us;  %warto poczatkowa u srednie
            vss(i,j)=vs;  %wartosc poczatkowa v srednie
            
            Exx=double(Exx);
            Eyy=double(Eyy);
            Ett=double(Ett);
            for k=1:iter    %wyznaczanie iteracyjne (poprawa rozwiazania po kazdym cyklu)
                
                us=us-Exx(i,j)*(Exx(i,j)*us+Eyy(i,j)*vs+Ett(i,j))*duu(i,j);
                vs=vs-Eyy(i,j)*(Exx(i,j)*us+Eyy(i,j)*vs+Ett(i,j))*duu(i,j);
                us1(i,j)=us;  %wartosc koncowa u
                vs1(i,j)=vs;  %wartosc koncowa v
                ii=(rozx-i)+1;  %dopasowanie rozmiaru do rozmiaru macierzy
                vs11(ii,j)=vs;
                us11(ii,j)=us;
            end
                  
    end
end
figure(3),cla,quiver(us11,vs11),title('Mapa przesuniec'),xlabel('piksle x'),ylabel('piksle y');